package org.msh.tb.reports;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.SynchronizationSummary;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.indicators.core.IndicatorFilters;
import org.msh.utils.EntityQuery;

@Name("synchronizationSummaryReport")
public class SynchronizationSummaryReport extends EntityQuery<SynchronizationSummary> {

    @In
    IndicatorFilters indicatorFilters;

    private Long totalCreated;
    private Long totalUpdated;

    @Override
    protected String getCountEjbql() {
        return "select count(*) from SynchronizationSummary ".concat(getCondition());
    }

    @Override
    public String getEjbql() {
        return "from SynchronizationSummary ".concat(getCondition());
    }

    private String getCondition() {
        Tbunit tbunit = indicatorFilters.getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = indicatorFilters.getTbunitselection().getAuselection().getSelectedUnit();

        if (tbunit != null) {
            return "where tbunit.id = " + tbunit.getId();
        } else if (adminUnit != null) {
            return "where tbunit.adminUnit.code like '" + adminUnit.getCode() + "%'";
        }

        return "where workspace.id = #{defaultWorkspace.id}";
    }

    @Override
    public String getOrder() {
        return "execDate desc";
    }

    @Override
    public Integer getMaxResults() {
        return 50;
    }

    @Override
    public void refresh() {
        updateStatistics();
        super.refresh();
    }

    /**
     * Updates total created and total updated values based
     */
    private void updateStatistics() {
        totalCreated = (Long) getEntityManager()
                .createQuery("select sum(tbcasesCreated) from SynchronizationSummary ".concat(getCondition()))
                .getSingleResult();

        totalUpdated = (Long) getEntityManager()
                .createQuery("select sum(tbcasesUpdated) from SynchronizationSummary ".concat(getCondition()))
                .getSingleResult();
    }

    public Long getTotalCreated() {
        if(totalCreated == null) {
            updateStatistics();
        }
        return totalCreated;
    }

    public void setTotalCreated(Long totalCreated) {
        this.totalCreated = totalCreated;
    }

    public Long getTotalUpdated() {
        if(totalUpdated == null) {
            updateStatistics();
        }
        return totalUpdated;
    }

    public void setTotalUpdated(Long totalUpdated) {
        this.totalUpdated = totalUpdated;
    }
}
